// config: norepeat

#include "GetObjects.js"
#include "GetObject.js"
#include "WaitForDialogDone.js"

function DoFlow()
{
	var ui = moi.ui;
	var objectpicker = ui.createObjectPicker();
	
	// Get the objects to transform
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;
	
	// Next get the base object - curve or surface.

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'done' );
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.showUI( 'SelectBasePrompt' );
	moi.ui.endUIUpdate();
	
	objectpicker.allowCurves();
	objectpicker.allowFaces();
	objectpicker.autoFaceDrillDown = true;
	if ( !GetObject( objectpicker ) )
		return;
		
	var baseobj = objectpicker.objects.item(0);

	
	// Next get the target curve or target surface. If a base surface was selected then
	// a checkbox appears for projective mode - when projective mode is enabled a
	// brep is picked as the target instead of a single face.
	
	var projective = moi.ui.commandUI.projective.value;

	objectpicker.resetAllow();
	objectpicker.autoFaceDrillDown = false;
	if ( baseobj.isCurve )
	{
		objectpicker.allowCurves();
	}
	else
	{
		if ( projective )
			objectpicker.allowBReps();
		else
			objectpicker.allowFaces();
	}
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectBasePrompt' );
	if ( baseobj.isCurve )
	{
		moi.ui.showUI( 'SelectTargetCurvePrompt' );
	}
	else
	{
		moi.ui.showUI( 'ProjectiveContainer' );
		moi.ui.showUI( projective ? 'SelectTargetObjectPrompt' : 'SelectTargetSurfacePrompt' );
	}
	moi.ui.endUIUpdate();

	while ( 1 )
	{
		if ( !objectpicker.waitForEvent() )
			return false;
			
		if ( objectpicker.event == 'finished' )
			break;
			
		if ( objectpicker.event == 'projective' )
		{
			// When the projective checkbox is clicked, swap the prompts and swap the object
			// picker between targeting faces versus whole breps.
			projective = moi.ui.commandUI.projective.value;
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( projective ? 'SelectTargetSurfacePrompt' : 'SelectTargetObjectPrompt' );
			moi.ui.showUI( projective ? 'SelectTargetObjectPrompt' : 'SelectTargetSurfacePrompt' );
			moi.ui.endUIUpdate();
			
			objectpicker.resetAllow();
			if ( projective )
				objectpicker.allowBReps();
			else
				objectpicker.allowFaces();
		}
	}
	
	objectpicker.objects.lockSelection();
		
	var targetobj = objectpicker.objects.item(0);


	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectTargetCurvePrompt' );
	moi.ui.hideUI( 'SelectTargetSurfacePrompt' );
	moi.ui.hideUI( 'SelectTargetObjectPrompt' );
	moi.ui.hideUI( 'ProjectiveContainer' );
	moi.ui.hideUI( baseobj.isCurve ? 'flipnormal' : 'stretch' );
	if ( !baseobj.IsCurve && projective )
		moi.ui.hideUI( 'flipnormal' );
	if ( baseobj.IsCurve || !projective )
		moi.ui.hideUI( 'straight' );
	moi.ui.showUI( 'done' );
	moi.ui.showUI( 'OptionsPrompt' );
	moi.ui.showUI( 'FlowOptions' );
	moi.ui.endUIUpdate();

	
	var factory = moi.command.createFactory( 'flow' );
	factory.disableUpdate( true );
	factory.setInput( 0, objects );
	factory.setInput( 1, baseobj );
	factory.setInput( 2, targetobj );
	moi.ui.bindUIToInput( 'deleteinputs', 'value', factory.getInput(3) );
	moi.ui.bindUIToInput( 'stretch', 'value', factory.getInput(4) );
	moi.ui.bindUIToInput( 'rigid', 'value', factory.getInput(5) );
	moi.ui.bindUIToInput( 'flipnormal', 'value', factory.getInput(10) );	
	factory.setInput( 11, projective );
	if ( !baseobj.IsCurve && projective )
		moi.ui.bindUIToInput( 'straight', 'value', factory.getInput(12) );
	factory.disableUpdate( false );
	
	factory.update();
	
	if ( !WaitForDialogDone() )
	{
		factory.cancel();
		return;
	}
	
	factory.commit();
}

DoFlow();
